
Name
   nistimep.exe -- compare the time of the PC clock with the NIST 
		   internet time server. 
		   This version is for PCs which have a packet-driver
		   interface to the network.

Syntax
   nistimep  [ options ]

Description
   This program connects to the NIST internet time server named 
   time_a.timefreq.bldrdoc.gov using tcp/ip port 13.  The time
   server responds with a packet containing the time in a format
   similar to that used by the NIST Automated Computer Time Service
   (ACTS).  The received time is compared with the time of the local 
   clock, and the difference may be used to correct the local DOS clock.
   If the -C option is specified, the time of the CMOS battery clock 
   can also be checked and set. 

   This version uses the wattcp software library to provide tcp/ip 
   packets to a resident packet-driver.  The packet driver must be 
   loaded and running before the nistimep program can be used.


   The program may be called with the following options:

    (note that upper and lower case letters are distinct)

   -m0          Do not display the received time message.  The 
		time difference between the DOS clock and NIST (in 
		seconds) is written to the standard output.  A 
		positive value for the difference means that the
		the local clock is fast with respect to NIST.  The
		-c option is ignored.

   -m1 or -M    Display short time messages.  This is the default
		if the -m switch is not used.

   -m2          Display longer time messages including an explanation
		of each parameter.

   -s0          Do not set the local clock.

   -s1 or -S    Set the local clock only if the server is healthy.

   -s2          Set the local clock even if the server is not healthy.

   -s3          Query operator before setting the clock.  This is the
		default if the -s switch is not used.

   -c1 or -C    A CMOS battery clock is present.  Its time will be
		compared against NIST.  If a time set is requested,
		this clock will be set too.  This is the default
		if the -c switch is not used.

   -c0          A CMOS battery clock is not present or the clock
                interface to the system is not standard.


-z<val>         This switch specifies that the received time message in
		UTC is to be corrected for the time-zone of the user.  If
		the absolute value of <val> is less than 13, it represents
		the time difference between the Universal Time (formerly
		called GMT) and the user's time in hours, where positive
		values mean that the user is West of Greenwich and negative
		values are for locations East of Greenwich.  The US time
		zones are therefore specified by:

		-z5		Eastern Time
		-z6		Central Time
		-z7		Mountain Time
		-z8		Pacific Time
			etc.
		Universal Time (GMT) would be specified by:

		-z0

		and the time in Western Europe by:

		-z-1

		If the absolute value of <val> is greater than 12, then it
		represents the time difference as above, but the units are
		in minutes rather than hours so that zones whose time does
		not differ by an integral number of hours can be specified
		in this way.  The sign convention is the same as above.
		Thus US Mountain Time could also be specified using:

		-z420

		If the switch is not present, then US Mountain Time
		is assumed by default.

-d0		Do not correct time difference for Daylight Saving Time.

-d1 or -D	Correct for Daylight Saving Time using the 
		US transition dates (Daylight Saving Time starts on the
 		first Sunday in April and ends on the last Sunday in
		October).  

		If this switch is not present, then -d1 is assumed by
		default.

Message Format

	The message received from NIST is shown below:

			D  L
 MJD  YY MM DD HH MM SS ST S H  Adv.
49010 93-01-23 22:01:22 00 0 0  50.0 UTC(NIST) * 


The heading is not part of the message and is shown only
to identify the parameters.  The first number is the date 
expressed as a Modified Julian Day number (MJD), and the next 
6 values give the Universal Coordinated date and time (formerly 
called Greenwich Mean Time) as year, month, day, hour, minute and 
second.

	The eighth number is the daylight saving time flag, DST.
It is based on the continental US system, which has transitions on
the first Sunday in April and the last Sunday in October.

DST =  0 means standard time is currently in effect.
DST = 50 means daylight saving time is currently in effect.
DST = 51 means the transition from standard time to daylight time is
	 at 2am local time today.
DST =  1 means the transition from daylight time to standard time is
	 at 2am local time today.

DST > 51 gives advance notice of the number of days to the transition 
	 to daylight time.  The DST parameter is decremented at 0000 
	 every day during this advance notice period, and the transition
	 will occur when the parameter reaches 51 as discussed above.

1 < DST < 50  gives advance notice of the number of days to the 
	      transition to standard time.  The DST parameter is 
	      decremented at 0000 every day during this advance 
	      notice period, and the transition will occur when the
	      parameter reaches 1 as discussed above.

    The DST parameter is used by this version of the program, if
you have selected that the correction for Daylight Saving Time
should be applied if necessary.

	The next number is the leap second flag, LS.

LS = 0 means no leap second is scheduled.

LS = 1 means that a leap second is to be added as 23:59:60 on the
       last day of the current month.  The last minute will therefore
       be 61 seconds long. Leap seconds are usually added at the end
       of either June or December.

LS = 2 means that second 23:59:59 is to be dropped on the last day of 
       the current month.  The second following 23:59:58 will be 00:00:00
       of the next day.  This minute will therefore be 59 seconds 
       long.  This situation is unlikely to be necessary in the
       foreseeable future.

	Note that leap seconds are inserted or deleted at the specified
Universal Times, while daylight savings transitions are always with
respect to local time.  This version of the program does not use the LS
parameter.
	
	The health parameter, H, gives the health of the server:

H = 0 means that the server is healthy.

H = 1 means that the server is operating properly but that its
      time may be in error by up to 5 seconds. This state should
      change to fully healthy within 10 minutes.

H = 2 means that the server is operating properly but that its
      time is known to be wrong by more than 5 seconds.  

H = 3 means that the hardware or software have failed and that the
      time error is unknown.

	The advance parameter, ADV, gives the time advance of the
transmissions, in milliseconds.  Each time packet is sent out early
by this amount to compensate (approximately) for the network delay.

	The remaining characters on the line identify the time 
source and are included for compatibility with the ACTS time
system.
	
Restrictions

	This program uses a packet driver to interface to 
	the internet and this software must be running before
	nistimep is called.

Bugs

	This version does not estimate the transmission delay 
	in the network.  This is unlikely to be a limitation
	since the DOS clock can only be set or read to +/- 55 msec
	and the CMOS battery clock can only be read to the nearest
	second.  

Files
	nistimep.exe            Compiled and linked version of the program.
	nistimep.man            This document.

See also:

	timeserver.info
	read.me

Last Modified: 21 August 1993
