/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Event;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TinyClient {
    static final String VERSION = "3.0";
    static final String COPYRIGHT = "2007";
    DatagramSocket socket;
    byte[] receiveBuffer;
    DatagramPacket inPacket;
    String hostName;
    ClassLoader cl = this.getClass().getClassLoader();
    URL[] tinyClientIconURLs = new URL[]{this.cl.getResource("TinyIcon0.gif"), this.cl.getResource("TinyIcon1.gif")};
    FinishedFlag finishedFlag = new FinishedFlag();
    StatusBar statusBar;
    KeyboardRequestThread keyboardRequestThread;
    byte[] bootRequestBuffer = new byte[]{66, (byte)0, (byte)0, (byte)0, (byte)0, (byte)0, (byte)0, (byte)0, (byte)0};
    DatagramPacket bootRequestPacket;
    DosScreenManager dosScreenManager = new DosScreenManager();
    ScreenRequestSender currentScreenRequestSender;
    DosFrame dosFrame;
    String password;
    InetAddress hostAddress;
    int hostPort;
    int screenRate;
    int keyRate;
    boolean keyScanDebug;
    ViewRequestThread viewRequestThread;

    private String makeTitle(String state) {
        return new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append("TINY to ").append(this.hostName).toString()).append(" (").toString()).append(state).toString()).append(")").toString();
    }

    public void showAboutBox(Icon icon) {
        JOptionPane.showMessageDialog(null, new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append("TINY\r\nVersion ").append(VERSION).toString()).append("\r\n(c)").toString()).append(COPYRIGHT).toString()).append(" Josh Levine\r\nhttp://josh.com/tiny").toString(), "About TINY", 1, icon);
    }

    synchronized void sendBootRequest() {
        try {
            this.socket.send(this.bootRequestPacket);
            this.statusBar.incrementBootSendCount();
        }
        catch (IOException ex) {
            System.out.println(new StringBuffer().append("Error sending boot request:").append(ex.toString()).toString());
        }
    }

    synchronized void setScreenRequestSender(int index) {
        ScreenRequestSenderList.ScreenRequestSenderItem i = this.dosScreenManager.getScreenRequestSenderItemFromIndex(index);
        this.currentScreenRequestSender = i.getScreenRequestSender();
        this.statusBar.setScreenRequestSenderIndex(i.index);
    }

    static void copyBytes(String s, int sStart, int sEnd, byte[] d, int dStart) {
        int x = sStart;
        while (x < sEnd && x < s.length()) {
            d[dStart++] = s.charAt(x);
            ++x;
        }
    }

    public TinyClient(String hostName, int port, String password, int screenRate, int keyRate, boolean allowLeftClick, boolean showStatusBar, boolean keyScanDebug, int screenMode, int scale) throws IOException {
        this.password = password;
        this.hostName = hostName;
        this.hostPort = port;
        this.keyRate = keyRate;
        this.hostName = hostName;
        this.keyScanDebug = keyScanDebug;
        this.hostAddress = InetAddress.getByName(hostName);
        this.dosFrame = new DosFrame(allowLeftClick, showStatusBar, screenMode, scale);
        this.socket = new DatagramSocket();
        this.receiveBuffer = new byte[this.dosFrame.getMaxiumDataSize()];
        this.inPacket = new DatagramPacket(this.receiveBuffer, this.receiveBuffer.length);
        this.bootRequestPacket = new DatagramPacket(this.bootRequestBuffer, this.bootRequestBuffer.length, this.hostAddress, port);
        TinyClient.copyBytes(password, 0, 8, this.bootRequestBuffer, 1);
        this.screenRate = screenRate;
    }

    public void start() {
        this.dosFrame.start();
        new ProcessreceivedPacketsThread().start();
        this.viewRequestThread = new ViewRequestThread(this.password, this.hostAddress, this.hostPort, this.screenRate);
        this.viewRequestThread.start();
        this.keyboardRequestThread = new KeyboardRequestThread(this.password, this.hostAddress, this.hostPort, this.keyRate);
        this.keyboardRequestThread.start();
    }

    public void waitUntilFinished() {
        this.finishedFlag.waitUntilFinished();
    }

    public static void main(String[] args) throws Exception {
        int UDPPort = 25443;
        int screenRate = 200;
        int keyRate = 500;
        boolean allowLeftClick = true;
        boolean ShowStatusBar = false;
        boolean keyScanDebug = false;
        int screenMode = 0;
        int scale = 1;
        System.out.println(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append("TINY Client Version ").append(VERSION).toString()).append("(c)").toString()).append(COPYRIGHT).toString()).append(" Josh Levine [tiny").toString()).append('@').toString()).append("support.josh.com]").toString());
        int arg = 0;
        while (arg < args.length && args[arg].charAt(0) == '/') {
            if (args[arg].length() < 2) {
                System.out.println("Malformed argument, try TinyClient /? for help.");
                System.exit(1);
            }
            switch (Character.toUpperCase(args[arg].charAt(1))) {
                case '?': {
                    System.out.println("Syntax: TinyClient [/Dn] [/Kn] [/R] [/C] [/S] [/Px] [/Xfilename] [/Mn] [/Ln] host_address password");
                    System.out.println(new StringBuffer().append(new StringBuffer().append("Where : /Dn sets the delay between screen requests in milliseconds (default=").append(screenRate).toString()).append(")").toString());
                    System.out.println(new StringBuffer().append(new StringBuffer().append("        /Kn sets the delay between key requests in milliseconds (default=").append(keyRate).toString()).append(")").toString());
                    System.out.println("        /R  disable popup menus on left click (default=left or right click)");
                    System.out.println(new StringBuffer().append(new StringBuffer().append("        /Px sets target UDP port in hex (default=").append(Integer.toHexString(UDPPort)).toString()).append(")").toString());
                    System.out.println("        /S show status window on startup (default is don't show)");
                    System.out.println("        /C show key scan codes to console for diagnosic purposes");
                    System.out.println("        /X read in a custom key translation table from filename (can repeat)");
                    System.out.println("        /M startup in screen mode n (omit n for mode list)");
                    System.out.println("        /L startup with screen scaling n (default=1, 0=Full Screen)");
                    System.out.println("        host_address is the IP address or name of the host machine (required)");
                    System.out.println("        password is the password for the host machine (required)");
                    System.exit(1);
                    break;
                }
                case 'M': {
                    if (args[arg].length() < 3) {
                        System.out.println("Available screen modes:");
                        DosScreenManager d = new DosScreenManager();
                        int x = 0;
                        for (ScreenRequestSenderList.ScreenRequestSenderItem i : (Collection)d.getScreenRequestSenderList().screenRequestSenderItems) {
                            System.out.println(new StringBuffer().append(x).append(i.getFullName()).toString());
                            ++x;
                        }
                        System.exit(1);
                    }
                    screenMode = Integer.parseInt(args[arg].substring(2));
                    System.out.println(new StringBuffer().append("Initial screen request mode set to ").append(screenMode).toString());
                    break;
                }
                case 'D': {
                    screenRate = Integer.parseInt(args[arg].substring(2));
                    System.out.println(new StringBuffer().append(new StringBuffer().append("Delay between screen requests set to ").append(screenRate).toString()).append(" milliseconds.").toString());
                    break;
                }
                case 'K': {
                    keyRate = Integer.parseInt(args[arg].substring(2));
                    System.out.println(new StringBuffer().append(new StringBuffer().append("Delay between keyboard requests set to ").append(keyRate).toString()).append(" milliseconds.").toString());
                    break;
                }
                case 'L': {
                    scale = Integer.parseInt(args[arg].substring(2));
                    System.out.println(new StringBuffer().append(new StringBuffer().append("Initial screen scale set to ").append(scale).toString()).append("X").toString());
                    break;
                }
                case 'S': {
                    ShowStatusBar = true;
                    System.out.println("Enabled inital display of status bar");
                    break;
                }
                case 'R': {
                    allowLeftClick = false;
                    System.out.println("Set menu popups only on right click.");
                    break;
                }
                case 'C': {
                    keyScanDebug = true;
                    System.out.println("Will print diagnostic key scancodes to the console.");
                    break;
                }
                case 'P': {
                    UDPPort = Integer.parseInt(args[arg].substring(2), 16);
                    System.out.println(new StringBuffer().append(new StringBuffer().append("Targeting UDP port ").append(Integer.toHexString(UDPPort)).toString()).append(" on host.").toString());
                    break;
                }
                case 'X': {
                    String filename = args[arg].substring(2);
                    System.out.println(new StringBuffer().append(new StringBuffer().append("Reading custom key translation table from file '").append(filename).toString()).append("'...").toString());
                    int count = KeyLookupTable.readTranslationTable(filename);
                    System.out.println(new StringBuffer().append(new StringBuffer().append("Read ").append(count).toString()).append(" key translations.").toString());
                    break;
                }
                default: {
                    System.out.println(new StringBuffer().append(new StringBuffer().append("Unrecognized argument: ").append(args[arg]).toString()).append(", try TinyClient /? for help.").toString());
                    System.exit(1);
                }
            }
            ++arg;
        }
        if (arg + 2 != args.length) {
            System.out.println("Incorrect command line format, try TinyClient /? for help.");
            System.exit(1);
        }
        TinyClient tinyClient = new TinyClient(args[arg], UDPPort, args[arg + 1], screenRate, keyRate, allowLeftClick, ShowStatusBar, keyScanDebug, screenMode, scale);
        tinyClient.start();
        tinyClient.waitUntilFinished();
        System.exit(0);
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FinishedFlag {
        boolean finished = false;

        public synchronized void setFinished() {
            this.finished = true;
            this.notifyAll();
        }

        public synchronized void waitUntilFinished() {
            while (!this.finished) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }

        static /* synthetic */ TinyClient access$0(FinishedFlag finishedFlag) {
            return finishedFlag.TinyClient.this;
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    class StatusBar
    extends Frame {
        boolean changed;
        boolean displayed;
        int viewPacketsreceived;
        int viewRequestCount;
        int pendingkeyStrokeCount;
        int keystrokeSendCount;
        int keystrokeAckCount;
        int bootSendCount;
        String displayedModeName;
        int screenRequestSenderIndex;
        boolean sizeSetFlag;
        BufferedImage bufferedImage;
        Graphics bg;
        Insets insets;
        FontMetrics fm;
        static final int LINE_COUNT = 17;
        static final int PADDING = 10;

        public synchronized void setChanged() {
            this.changed = true;
            if (this.displayed) {
                this.repaint();
            }
        }

        public synchronized void setDisplayed(boolean displayed) {
            if (!displayed ? !this.displayed : this.displayed) {
                return;
            }
            if (displayed) {
                this.setFocusTraversalKeysEnabled(false);
                this.setResizable(false);
                this.setVisible(true);
                this.displayed = true;
                this.repaint();
            } else {
                this.setVisible(false);
                this.displayed = false;
            }
        }

        public void toggleDisplayedState() {
            this.setDisplayed(!this.displayed);
        }

        @Override
        public boolean handleEvent(Event evt) {
            if (evt.id == 201) {
                this.setDisplayed(false);
                return true;
            }
            return super.handleEvent(evt);
        }

        public synchronized void incrementViewPacketCount() {
            ++this.viewPacketsreceived;
            this.setChanged();
        }

        public synchronized void incrementViewRequestCount() {
            ++this.viewRequestCount;
            this.setChanged();
        }

        public synchronized void incrementpendingKeyStrokeCount() {
            ++this.pendingkeyStrokeCount;
            this.setChanged();
        }

        public synchronized void decrementpendingKeyStrokeCount() {
            this.pendingkeyStrokeCount += -1;
            this.setChanged();
        }

        public synchronized void incrementKeystrokeSendCount() {
            ++this.keystrokeSendCount;
            this.setChanged();
        }

        public synchronized void incrementKeystokeAckCount() {
            ++this.keystrokeAckCount;
            this.setChanged();
        }

        public synchronized void incrementBootSendCount() {
            ++this.bootSendCount;
            this.setChanged();
        }

        public synchronized void setDisplayedModeName(String modeName) {
            this.displayedModeName = modeName;
            this.setChanged();
        }

        public synchronized void setScreenRequestSenderIndex(int index) {
            this.screenRequestSenderIndex = index;
            this.setChanged();
        }

        public StatusBar() {
            super("TINY Stats");
            this.changed = true;
            this.displayed = false;
            this.viewPacketsreceived = 0;
            this.viewRequestCount = 0;
            this.pendingkeyStrokeCount = 0;
            this.keystrokeSendCount = 0;
            this.keystrokeAckCount = 0;
            this.bootSendCount = 0;
            this.displayedModeName = "NONE";
            this.sizeSetFlag = false;
            super.setIconImage(this.getToolkit().getImage(TinyClient.this.tinyClientIconURLs[0]));
        }

        private void clear() {
            this.bg.clearRect(0, 0, this.bufferedImage.getWidth(), this.bufferedImage.getHeight());
        }

        private void printline(int line, String left, String right, Color color) {
            int baseline = line * this.fm.getHeight() + this.fm.getHeight();
            this.bg.setColor(color);
            this.bg.drawString(left, 10, baseline);
            this.bg.drawString(right, this.bufferedImage.getWidth() - 10 - this.fm.stringWidth(right), baseline);
        }

        @Override
        public synchronized void update(Graphics g) {
            if (!this.sizeSetFlag) {
                this.fm = g.getFontMetrics();
                this.insets = this.getInsets();
                this.bufferedImage = new BufferedImage(this.fm.stringWidth(" SEND PACKET COUNT:                         99999999 "), this.fm.getHeight() * 17, 1);
                this.bg = this.bufferedImage.getGraphics();
                this.setSize(this.bufferedImage.getWidth() + this.insets.left + this.insets.right, this.bufferedImage.getHeight() + this.insets.bottom + this.insets.top);
                this.sizeSetFlag = true;
            }
            if (this.changed) {
                this.clear();
                this.printline(1, "Host IP", TinyClient.this.hostAddress.getHostAddress(), Color.WHITE);
                this.printline(2, "Host Port", new StringBuffer().append("0x").append(Integer.toHexString(TinyClient.this.hostPort)).toString(), Color.WHITE);
                this.printline(4, "Requested Mode", Integer.toString(this.screenRequestSenderIndex), Color.WHITE);
                this.printline(5, "Displayed Mode", this.displayedModeName, Color.WHITE);
                this.printline(7, "View requests", Integer.toString(this.viewRequestCount), Color.WHITE);
                this.printline(8, "View responses", Integer.toString(this.viewPacketsreceived), Color.WHITE);
                this.printline(9, "Lost Views", Integer.toString(this.viewRequestCount - this.viewPacketsreceived), Color.RED);
                this.printline(11, "Key requests", Integer.toString(this.keystrokeSendCount), Color.WHITE);
                this.printline(12, "Key ACKs", Integer.toString(this.keystrokeAckCount), Color.WHITE);
                this.printline(13, "Lost Key Packets", Integer.toString(this.keystrokeSendCount - this.keystrokeAckCount), Color.RED);
                this.printline(15, "Pending keys", Integer.toString(this.pendingkeyStrokeCount), Color.WHITE);
                this.changed = false;
            }
            g.drawImage(this.bufferedImage, this.insets.left, this.insets.top, null);
        }

        @Override
        public void paint(Graphics g) {
            this.update(g);
        }

        static /* synthetic */ TinyClient access$0(StatusBar statusBar) {
            return statusBar.TinyClient.this;
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    class KeyboardRequestThread
    extends Thread {
        static final int KEYSTROKE_QUEUE_SIZE = 20;
        static final int TOKEN_VALUE_MAX = 10000;
        static final int TOKEN_VALUE_REJECT = 10001;
        byte[] keyRequestBuffer = new byte[]{76, (byte)0, (byte)0, (byte)0, (byte)0, (byte)0, (byte)0, (byte)0, (byte)0, 0, 0, 0, 0};
        DatagramPacket keyRequestPacket;
        int delay;
        int[] queue = new int[20];
        int head = 0;
        int tail = 0;
        int pendingToken = 0;

        public KeyboardRequestThread(String password, InetAddress hostAddress, int hostPort, int delay) {
            this.keyRequestPacket = new DatagramPacket(this.keyRequestBuffer, this.keyRequestBuffer.length, hostAddress, hostPort);
            TinyClient.copyBytes(password, 0, 8, this.keyRequestBuffer, 1);
            this.delay = delay;
        }

        private void sendKeyboardRequestPacket(int code, int token) {
            this.keyRequestBuffer[9] = (byte)(token & 0xFF);
            this.keyRequestBuffer[10] = (byte)(token >>> 8 & 0xFF);
            this.keyRequestBuffer[11] = (byte)(code & 0xFF);
            this.keyRequestBuffer[12] = (byte)(code >>> 8 & 0xFF);
            try {
                TinyClient.this.socket.send(this.keyRequestPacket);
                TinyClient.this.statusBar.incrementKeystrokeSendCount();
            }
            catch (IOException ex) {
                System.out.println(new StringBuffer().append("Error sending keystroke:").append(ex.toString()).toString());
            }
        }

        private int incptr(int x) {
            if (++x == 20) {
                return 0;
            }
            return x;
        }

        public synchronized void putKeystroke(int code) {
            this.queue[this.head] = code;
            boolean wasEmpty = this.head == this.tail;
            this.head = this.incptr(this.head);
            TinyClient.this.statusBar.incrementpendingKeyStrokeCount();
            if (this.head == this.tail) {
                this.tail = this.incptr(this.tail);
                TinyClient.this.statusBar.decrementpendingKeyStrokeCount();
            }
            if (wasEmpty) {
                this.notify();
            }
        }

        public synchronized void ackKeyStroke(int token) {
            if (this.head != this.tail && (token == this.pendingToken || token == 10001)) {
                ++this.pendingToken;
                TinyClient.this.statusBar.incrementKeystokeAckCount();
                if (this.pendingToken == 10000) {
                    this.pendingToken = 0;
                }
                this.tail = this.incptr(this.tail);
                TinyClient.this.statusBar.decrementpendingKeyStrokeCount();
                if (this.tail != this.head) {
                    this.notify();
                }
            }
        }

        @Override
        public synchronized void run() {
            this.putKeystroke(0);
            try {
                while (true) {
                    if (this.head != this.tail) {
                        this.sendKeyboardRequestPacket(this.queue[this.tail], this.pendingToken);
                    }
                    if (this.head == this.tail) {
                        this.wait();
                        continue;
                    }
                    this.wait(this.delay);
                }
            }
            catch (InterruptedException ex) {
                System.out.println(new StringBuffer().append("Keyboard send thread interrupted:").append(ex.toString()).toString());
                return;
            }
        }

        static /* synthetic */ TinyClient access$0(KeyboardRequestThread keyboardRequestThread) {
            return keyboardRequestThread.TinyClient.this;
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DosFrame
    extends Frame {
        boolean newModeFlag;
        boolean allowLeftClick;
        DosPopupMenu dosPopupMenu;
        DosScreen currentDosScreen;
        DosScreen displayedDosScreen;
        long nextIconChange;
        int iconIndex;
        static final long ICON_UPDATE_DELAY = 1000L;
        int scale;

        public DosFrame(boolean allowLeftClick, boolean showStatusBar, int defaultScreenRequestSenderIndex, int scale) {
            super(TinyClient.this.makeTitle("(Waiting)"));
            this.newModeFlag = true;
            this.dosPopupMenu = new DosPopupMenu();
            this.currentDosScreen = TinyClient.this.dosScreenManager.getNoneScreen();
            this.displayedDosScreen = null;
            this.nextIconChange = 0;
            this.iconIndex = 0;
            this.scale = 1;
            this.allowLeftClick = allowLeftClick;
            this.scale = scale;
            TinyClient.this.statusBar = new StatusBar();
            TinyClient.this.statusBar.setDisplayed(showStatusBar);
            TinyClient.this.setScreenRequestSender(defaultScreenRequestSenderIndex);
        }

        Menu makeSreenModesMenu(String name, ArrayList<ScreenRequestSenderList.ScreenRequestSenderNode> subNodes) {
            Menu m = new Menu(name);
            for (ScreenRequestSenderList.ScreenRequestSenderNode node : (Collection)subNodes) {
                if (node.isLeaf()) {
                    ScreenRequestSenderList.ScreenRequestSenderNodeLeaf leaf = (ScreenRequestSenderList.ScreenRequestSenderNodeLeaf)node;
                    MenuItem mi = new MenuItem(leaf.name);
                    mi.addActionListener(new ScreenModeMenuChoiceActionListener(leaf.index));
                    m.add(mi);
                    continue;
                }
                ScreenRequestSenderList.ScreenRequestSenderNodeBranch branch = (ScreenRequestSenderList.ScreenRequestSenderNodeBranch)node;
                m.add(this.makeSreenModesMenu(branch.name, branch.subNodes));
            }
            return m;
        }

        public void display() {
            this.add(this.dosPopupMenu);
            this.setFocusTraversalKeysEnabled(false);
            this.setResizable(false);
            this.setVisible(true);
        }

        public void start() {
            this.setIconImage(this.getToolkit().getImage(TinyClient.this.tinyClientIconURLs[0]));
            this.display();
        }

        public int getMaxiumDataSize() {
            return TinyClient.this.dosScreenManager.getMaxiumDataSize();
        }

        public synchronized void setScale(int scale) {
            this.scale = scale;
            this.newModeFlag = true;
            this.repaint();
        }

        public synchronized void updateScreen(byte[] data, int len) {
            this.currentDosScreen = TinyClient.this.dosScreenManager.findDosScreen(len);
            if (this.currentDosScreen != this.displayedDosScreen) {
                this.newModeFlag = true;
            }
            if (this.currentDosScreen.update(data, len) || this.newModeFlag) {
                this.repaint();
                long now = System.currentTimeMillis();
                if (now > this.nextIconChange) {
                    ++this.iconIndex;
                    if (this.iconIndex >= TinyClient.this.tinyClientIconURLs.length) {
                        this.iconIndex = 0;
                    }
                    this.setIconImage(this.getToolkit().getImage(TinyClient.this.tinyClientIconURLs[this.iconIndex]));
                    this.nextIconChange = now + 1000L;
                }
            }
        }

        @Override
        public synchronized void update(Graphics g) {
            BufferedImage bufferedImage = this.currentDosScreen.getBufferedImage();
            Insets insets = this.getInsets();
            if (this.newModeFlag) {
                TinyClient.this.statusBar.setDisplayedModeName(this.currentDosScreen.getName());
                this.setTitle(TinyClient.this.makeTitle(this.currentDosScreen.getName()));
                if (this.scale == 0) {
                    if (GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getFullScreenWindow() == null) {
                        GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().setFullScreenWindow(this);
                    }
                } else {
                    if (GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getFullScreenWindow() != null) {
                        GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().setFullScreenWindow(null);
                    }
                    this.setSize(bufferedImage.getWidth() * this.scale + insets.left + insets.right, bufferedImage.getHeight() * this.scale + insets.bottom + insets.top);
                }
                this.displayedDosScreen = this.currentDosScreen;
                this.newModeFlag = false;
            }
            BufferedImage bufferedImage2 = bufferedImage;
            synchronized (bufferedImage2) {
                if (this.scale == 1) {
                    g.drawImage(bufferedImage, insets.left, insets.top, null);
                } else if (this.scale == 0) {
                    g.drawImage(bufferedImage, insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom, null);
                } else {
                    g.drawImage(bufferedImage, insets.left, insets.top, bufferedImage.getWidth() * this.scale, bufferedImage.getHeight() * this.scale, null);
                }
            }
        }

        @Override
        public void paint(Graphics g) {
            this.update(g);
        }

        @Override
        public boolean keyDown(Event evt, int key) {
            int code;
            if (TinyClient.this.keyScanDebug) {
                System.out.println(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append("KeyDown modifiers = ").append(Integer.toHexString(evt.modifiers)).toString()).append(" key=").toString()).append(key).toString());
            }
            if ((code = KeyLookupTable.customTableLookup(evt.modifiers, key)) >= 0) {
                TinyClient.this.keyboardRequestThread.putKeystroke(code);
                return true;
            }
            int i = 0;
            while (i < PcKeyboard.keys.length) {
                if (key == PcKeyboard.keys[i].lookup) {
                    code = (evt.modifiers & 8) != 0 ? PcKeyboard.keys[i].alt : ((evt.modifiers & 2) != 0 ? PcKeyboard.keys[i].control : ((evt.modifiers & 1) != 0 ? PcKeyboard.keys[i].shift : PcKeyboard.keys[i].normal));
                    TinyClient.this.keyboardRequestThread.putKeystroke(code);
                    return true;
                }
                ++i;
            }
            return false;
        }

        @Override
        public boolean handleEvent(Event evt) {
            if (evt.id == 201) {
                TinyClient.this.finishedFlag.setFinished();
                return true;
            }
            return super.handleEvent(evt);
        }

        @Override
        public boolean mouseDown(Event evt, int x, int y) {
            if (this.allowLeftClick) {
                new 100000000.StupidPopupThread(this, x, y).start();
            } else if (evt.metaDown()) {
                new 100000000.StupidPopupThread(this, x, y).start();
            }
            return true;
        }

        /*
         * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
         */
        class DosPopupMenu
        extends PopupMenu
        implements ActionListener {
            public DosPopupMenu() {
                this.add("Cancel");
                Menu keystrokeMenus = new Menu("Send Keystroke");
                keystrokeMenus.add(new LocalKeystrokeMenu("Normal", new NormalModifierLookup()));
                keystrokeMenus.add(new LocalKeystrokeMenu("Shift", new ShiftModifierLookup()));
                keystrokeMenus.add(new LocalKeystrokeMenu("Control", new ControlModifierLookup()));
                keystrokeMenus.add(new LocalKeystrokeMenu("Alt", new AltModifierLookup()));
                if (KeyLookupTable.customKeys != null) {
                    keystrokeMenus.add(new CustomKeystrokeMenu("Custom Keys", KeyLookupTable.customKeys));
                }
                this.add(keystrokeMenus);
                this.add(new RebootMenu());
                this.addSeparator();
                this.add(DosFrame.this.makeSreenModesMenu("Host Screen Mode", ((DosFrame)DosFrame.this).TinyClient.this.dosScreenManager.getScreenRequestSenderRootNode().subNodes));
                this.add(new ScaleMenu());
                this.add("Toggle Stats");
                this.addSeparator();
                this.add("Hang up");
                this.add("About");
                this.addActionListener(this);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equalsIgnoreCase("Toggle Stats")) {
                    ((DosFrame)DosFrame.this).TinyClient.this.statusBar.toggleDisplayedState();
                    DosFrame.this.repaint();
                    return;
                }
                if (e.getActionCommand().equalsIgnoreCase("Hang up")) {
                    ((DosFrame)DosFrame.this).TinyClient.this.finishedFlag.setFinished();
                    return;
                }
                if (e.getActionCommand().equalsIgnoreCase("About")) {
                    TinyClient.this.showAboutBox(new ImageIcon(DosFrame.this.getToolkit().getImage(((DosFrame)DosFrame.this).TinyClient.this.tinyClientIconURLs[0])));
                    return;
                }
            }

            /*
             * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
             */
            class RebootMenu
            extends Menu
            implements ActionListener {
                public RebootMenu() {
                    super("Reboot Host");
                    this.add("Cancel");
                    this.add("Reboot Now");
                    this.addActionListener(this);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getActionCommand().equalsIgnoreCase("Reboot Now")) {
                        TinyClient.this.sendBootRequest();
                    }
                }

                static /* synthetic */ DosPopupMenu access$0(RebootMenu rebootMenu) {
                    return rebootMenu.DosPopupMenu.this;
                }
            }

            class ScaleMenu
            extends Menu {
                public ScaleMenu() {
                    super("Scale Screen");
                    this.add("Cancel");
                    this.add(new ScaleMenuItem("1x", 1));
                    this.add(new ScaleMenuItem("2x", 2));
                    this.add(new ScaleMenuItem("3x", 3));
                    this.add(new ScaleMenuItem("4x", 4));
                    this.add(new ScaleMenuItem("Full Screen", 0));
                }

                /*
                 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
                 */
                class ScaleMenuItem
                extends MenuItem
                implements ActionListener {
                    int scale;

                    public ScaleMenuItem(String label, int scale) {
                        super(label);
                        this.scale = scale;
                        this.addActionListener(this);
                    }

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DosFrame.this.setScale(this.scale);
                    }

                    static /* synthetic */ ScaleMenu access$0(ScaleMenuItem scaleMenuItem) {
                        return scaleMenuItem.ScaleMenu.this;
                    }
                }
            }
        }

        abstract class ModifierLookup {
            abstract int getCode(PcKeyboard.LocalKey var1);

            static /* synthetic */ DosFrame access$0(ModifierLookup modifierLookup) {
                return modifierLookup.DosFrame.this;
            }
        }

        class NormalModifierLookup
        extends ModifierLookup {
            int getCode(PcKeyboard.LocalKey key) {
                return key.normal;
            }

            static /* synthetic */ DosFrame access$0(NormalModifierLookup normalModifierLookup) {
                return normalModifierLookup.DosFrame.this;
            }
        }

        class ShiftModifierLookup
        extends ModifierLookup {
            int getCode(PcKeyboard.LocalKey key) {
                return key.shift;
            }

            static /* synthetic */ DosFrame access$0(ShiftModifierLookup shiftModifierLookup) {
                return shiftModifierLookup.DosFrame.this;
            }
        }

        class ControlModifierLookup
        extends ModifierLookup {
            int getCode(PcKeyboard.LocalKey key) {
                return key.control;
            }

            static /* synthetic */ DosFrame access$0(ControlModifierLookup controlModifierLookup) {
                return controlModifierLookup.DosFrame.this;
            }
        }

        class AltModifierLookup
        extends ModifierLookup {
            int getCode(PcKeyboard.LocalKey key) {
                return key.alt;
            }

            static /* synthetic */ DosFrame access$0(AltModifierLookup altModifierLookup) {
                return altModifierLookup.DosFrame.this;
            }
        }

        class LocalKeystrokeMenu
        extends Menu {
            public LocalKeystrokeMenu(String modifierName, ModifierLookup modifierLookup) {
                super(modifierName);
                int i = 0;
                while (i < PcKeyboard.keys.length) {
                    MenuItem mi = new MenuItem(PcKeyboard.keys[i].name);
                    LocalKeystrokeMenuChoiceActionListener l = new LocalKeystrokeMenuChoiceActionListener(modifierLookup.getCode(PcKeyboard.keys[i]));
                    mi.addActionListener(l);
                    this.add(mi);
                    ++i;
                }
            }

            /*
             * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
             */
            class LocalKeystrokeMenuChoiceActionListener
            implements ActionListener {
                int dosKeyCode;

                LocalKeystrokeMenuChoiceActionListener(int dosKeyCode) {
                    this.dosKeyCode = dosKeyCode;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((DosFrame)((LocalKeystrokeMenu)LocalKeystrokeMenu.this).DosFrame.this).TinyClient.this.keyboardRequestThread.putKeystroke(this.dosKeyCode);
                }

                static /* synthetic */ LocalKeystrokeMenu access$0(LocalKeystrokeMenuChoiceActionListener localKeystrokeMenuChoiceActionListener) {
                    return localKeystrokeMenuChoiceActionListener.LocalKeystrokeMenu.this;
                }
            }
        }

        class CustomKeystrokeMenu
        extends Menu {
            public CustomKeystrokeMenu(String name, KeyLookupTable.CustomKey[] keys) {
                super(name);
                KeyLookupTable.CustomKey[] customKeyArray = keys;
                int n = 0;
                while (n < customKeyArray.length) {
                    KeyLookupTable.CustomKey k = customKeyArray[n];
                    MenuItem mi = new MenuItem(k.name);
                    mi.addActionListener(new CustomKeystrokeMenuChoiceListener(k.doscode));
                    this.add(mi);
                    ++n;
                }
            }

            /*
             * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
             */
            class CustomKeystrokeMenuChoiceListener
            implements ActionListener {
                int dosKeyCode;

                CustomKeystrokeMenuChoiceListener(int dosKeyCode) {
                    this.dosKeyCode = dosKeyCode;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((DosFrame)((CustomKeystrokeMenu)CustomKeystrokeMenu.this).DosFrame.this).TinyClient.this.keyboardRequestThread.putKeystroke(this.dosKeyCode);
                }

                static /* synthetic */ CustomKeystrokeMenu access$0(CustomKeystrokeMenuChoiceListener customKeystrokeMenuChoiceListener) {
                    return customKeystrokeMenuChoiceListener.CustomKeystrokeMenu.this;
                }
            }
        }

        /*
         * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
         */
        class ScreenModeMenuChoiceActionListener
        implements ActionListener {
            int index;

            ScreenModeMenuChoiceActionListener(int index) {
                this.index = index;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                TinyClient.this.setScreenRequestSender(this.index);
            }

            static /* synthetic */ DosFrame access$0(ScreenModeMenuChoiceActionListener screenModeMenuChoiceActionListener) {
                return screenModeMenuChoiceActionListener.DosFrame.this;
            }
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ProcessreceivedPacketsThread
    extends Thread {
        @Override
        public void run() {
            try {
                while (!TinyClient.this.socket.isClosed()) {
                    TinyClient.this.inPacket.setLength(TinyClient.this.receiveBuffer.length);
                    TinyClient.this.socket.receive(TinyClient.this.inPacket);
                    if (TinyClient.this.inPacket.getLength() == 2) {
                        int token = TinyClient.this.receiveBuffer[0] & 0xFF | (TinyClient.this.receiveBuffer[1] & 0xFF) << 8;
                        TinyClient.this.keyboardRequestThread.ackKeyStroke(token);
                        continue;
                    }
                    TinyClient.this.statusBar.incrementViewPacketCount();
                    TinyClient.this.dosFrame.updateScreen(TinyClient.this.receiveBuffer, TinyClient.this.inPacket.getLength());
                    TinyClient.this.dosFrame.repaint();
                }
            }
            catch (IOException ex) {
                System.out.println(new StringBuffer().append("Error reading recieved packet:").append(ex.toString()).toString());
            }
        }

        static /* synthetic */ TinyClient access$0(ProcessreceivedPacketsThread processreceivedPacketsThread) {
            return processreceivedPacketsThread.TinyClient.this;
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ViewRequestThread
    extends Thread {
        byte[] viewRequestBuffer = new byte[ScreenRequestSender.BUFFER_SIZE];
        DatagramPacket viewRequestPacket;
        int delay;

        @Override
        public void run() {
            try {
                while (!TinyClient.this.socket.isClosed()) {
                    TinyClient.this.currentScreenRequestSender.fillRequestPacket(this.viewRequestBuffer, TinyClient.this.dosFrame.currentDosScreen.getLastBitPlane(), TinyClient.this.dosFrame.currentDosScreen.getLastSlice());
                    TinyClient.this.socket.send(this.viewRequestPacket);
                    TinyClient.this.statusBar.incrementViewRequestCount();
                    Thread.sleep(this.delay);
                }
            }
            catch (IOException ex) {
                System.out.println(new StringBuffer().append("Error sending view request:").append(ex.toString()).toString());
            }
            catch (InterruptedException ex) {}
        }

        ViewRequestThread(String password, InetAddress hostAddress, int hostPort, int delay) {
            this.delay = delay;
            this.viewRequestPacket = new DatagramPacket(this.viewRequestBuffer, this.viewRequestBuffer.length, hostAddress, hostPort);
            TinyClient.copyBytes(password, 0, 8, this.viewRequestBuffer, 1);
        }

        static /* synthetic */ TinyClient access$0(ViewRequestThread viewRequestThread) {
            return viewRequestThread.TinyClient.this;
        }
    }
}

