/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DosScreenManager {
    ScreenRequestSenderList screenRequestSenderList;
    ArrayList<DosScreen> dosScreenList = new ArrayList();
    DosScreen unknownScreen = new DosScreenUnknownSize();
    DosScreen noneScreen = new DosScreenNone();
    private static /* synthetic */ boolean $assertionsDisabled;

    public ScreenRequestSenderList.ScreenRequestSenderNodeBranch getScreenRequestSenderRootNode() {
        return this.screenRequestSenderList.getRootNode();
    }

    public DosScreen findDosScreen(int dataSize) {
        for (DosScreen screen : (Collection)this.dosScreenList) {
            if (screen.getSignatureDataLength() != dataSize) continue;
            return screen;
        }
        return this.unknownScreen;
    }

    private void addScreen(DosScreen dosScreen) {
        if (this.findDosScreen(dosScreen.getSignatureDataLength()) != null && !$assertionsDisabled) {
            throw new AssertionError((Object)new StringBuffer().append(new StringBuffer().append(new StringBuffer().append("Tried to add a screen with an existing signature length NEW:").append(dosScreen.getName()).toString()).append(" EXISTING:").toString()).append(this.findDosScreen(dosScreen.getSignatureDataLength()).getName()).toString());
        }
        this.dosScreenList.add(dosScreen);
        ScreenRequestSenderList.ScreenRequestSenderNodeBranch rootNode = this.screenRequestSenderList.getRootNode();
        dosScreen.addScreenRequestSenders(rootNode);
    }

    public DosScreen getDosScreenFromIndex(int index) {
        return this.dosScreenList.get(index);
    }

    public int getMaxiumDataSize() {
        int maxsize = 0;
        for (DosScreen screen : (Collection)this.dosScreenList) {
            if (screen.getSignatureDataLength() <= maxsize) continue;
            maxsize = screen.getSignatureDataLength();
        }
        return maxsize;
    }

    ScreenRequestSenderList getScreenRequestSenderList() {
        return this.screenRequestSenderList;
    }

    public DosScreen getNoneScreen() {
        return this.noneScreen;
    }

    ScreenRequestSenderList.ScreenRequestSenderItem getScreenRequestSenderItemFromIndex(int index) {
        return this.screenRequestSenderList.getScreenRequestSenderItemFromIndex(index);
    }

    int getdefaultScreenRequestSenderIndex() {
        return 0;
    }

    public DosScreenManager() {
        this.screenRequestSenderList = new ScreenRequestSenderList();
        this.addScreen(new DosScreenAutomatic());
        this.addScreen(new DosScreenAutomaticCompatible());
        this.addScreen(new DosScreenText(40, 25, 1, 4));
        this.addScreen(new DosScreenText(80, 25, 2, 2));
        this.addScreen(new DosScreenText(80, 43, 3, 1));
        this.addScreen(new DosScreenText(80, 50, 4, 1));
        this.addScreen(new DosScreenVGA16(320, 200, 4, 4, 5));
        this.addScreen(new DosScreenVGA16(640, 200, 4, 4, 6));
        this.addScreen(new DosScreenVGA16(640, 350, 2, 8, 7));
        this.addScreen(new DosScreenVGA16(640, 350, 4, 10, 8));
        this.addScreen(new DosScreenVGA16(640, 480, 4, 10, 9));
        this.addScreen(new DosScreenHerc(720, 348, 4, 3, 10));
        this.addScreen(new DosScreenUnsupportedMode());
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("DosScreenManager");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }
}

