/*
 * Decompiled with CFR 0.152.
 */
import java.awt.image.BufferedImage;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DosScreenHerc
extends DosScreen {
    private String name;
    private BufferedImage bufferedImage;
    public int signatureSize;
    final int sizeX;
    final int sizeY;
    final int bitplanes;
    final int slices;
    final int sliceSize;
    final int bytesPerLine;
    final int linesPerSlice;
    int viewRequestCode;
    static final int RGB_BLACK = 0xFFFFFF;
    static final int RGB_WHITE = 0;
    int lastBitPlane = 255;
    int lastSlice = 255;

    @Override
    public BufferedImage getBufferedImage() {
        return this.bufferedImage;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public DosScreenHerc(int width, int height, int bitplanes, int slices, int viewRequestCode) {
        this.sizeX = width;
        this.sizeY = height;
        this.bitplanes = bitplanes;
        this.slices = slices;
        this.sliceSize = this.sizeX / 8 * (this.sizeY / bitplanes / slices);
        this.bytesPerLine = this.sizeX / 8;
        this.linesPerSlice = this.sliceSize / this.bytesPerLine;
        this.viewRequestCode = viewRequestCode;
        this.bufferedImage = new BufferedImage(this.sizeX, this.sizeY, 12);
        this.name = new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append("Herc ").append(width).toString()).append("x").toString()).append(height).toString()).append("x").toString()).append(bitplanes).toString()).append("/").toString()).append(slices).toString();
        this.signatureSize = this.sliceSize + 2;
    }

    @Override
    public int getLastBitPlane() {
        return this.lastBitPlane;
    }

    @Override
    public int getLastSlice() {
        return this.lastSlice;
    }

    @Override
    public boolean update(byte[] data, int len) {
        int bitplane = data[this.sliceSize + 0] & 0xFF;
        int slice = data[this.sliceSize + 1] & 0xFF;
        if (bitplane >= this.bitplanes || slice >= this.slices) {
            System.out.println(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append("Recieved a corrupted frame: slice=").append(slice).toString()).append(" bitplane=").toString()).append(bitplane).toString()).append(" [").toString()).append(this.name).toString()).append("]").toString());
            return false;
        }
        this.lastBitPlane = bitplane;
        this.lastSlice = slice;
        int y = slice * (this.linesPerSlice * this.bitplanes) + bitplane;
        int index = 0;
        int line = 0;
        while (line < this.linesPerSlice) {
            int x = 0;
            int byteInLine = 0;
            while (byteInLine < this.bytesPerLine) {
                int mask = 128;
                int bit = 0;
                while (bit < 8) {
                    if ((data[index] & mask) == 0) {
                        this.bufferedImage.setRGB(x, y, 0);
                    } else {
                        this.bufferedImage.setRGB(x, y, 0xFFFFFF);
                    }
                    ++x;
                    mask >>= 1;
                    ++bit;
                }
                ++index;
                ++byteInLine;
            }
            y += 4;
            ++line;
        }
        return true;
    }

    @Override
    public int getSignatureDataLength() {
        return this.signatureSize;
    }

    void addScanSystems(ScreenRequestSenderList.ScreenRequestSenderNodeBranch node, int mode, int page) {
        node.addLeaf("Progressive", new ScreenRequestSender(87, mode, 0, page));
        node.addLeaf("Interlaced", new ScreenRequestSender(87, mode, 1, page));
    }

    @Override
    void addScreenRequestSenders(ScreenRequestSenderList.ScreenRequestSenderNodeBranch node) {
        ScreenRequestSenderList.ScreenRequestSenderNodeBranch subNode = node.addBranch(this.name);
        int page = 0;
        while (page < 2) {
            ScreenRequestSenderList.ScreenRequestSenderNodeBranch subsubNode = subNode.addBranch(new StringBuffer().append("Page #").append(page).toString());
            this.addScanSystems(subsubNode, this.viewRequestCode, page);
            ++page;
        }
    }
}

